/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public class PotionCastingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    private final class_3956<?> type;
    private final class_1865<?> serializer;
    private final class_2960 id;
    private final String group;
    private final class_1856 bottle;
    private final FluidIngredient fluid;
    private final class_1792 result;
    private final int coolingTime;
    private List<DisplayCastingRecipe> displayRecipes = null;

    public boolean matches(ICastingContainer inv, class_1937 level) {
        return this.bottle.method_8093(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public long getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    public class_1799 assemble(ICastingContainer inv, class_5455 registryAccess) {
        class_1799 result = new class_1799((class_1935)this.result);
        result.method_7980(inv.getFluidTag());
        return result;
    }

    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<class_1799> bottles = List.of(this.bottle.method_8105());
            this.displayRecipes = class_7923.field_41179.method_10220().map(potion -> {
                class_1799 result = class_1844.method_8061((class_1799)new class_1799((class_1935)this.result), (class_1842)potion);
                return new DisplayCastingRecipe(this.type, bottles, this.fluid.getFluids().stream().map(fluid -> new FluidStack(fluid.getFluid(), fluid.getAmount(), result.method_7969())).toList(), result, this.coolingTime, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.bottle});
    }

    @Deprecated
    public class_1799 method_8110(class_5455 registryAccess) {
        return new class_1799((class_1935)this.result);
    }

    public PotionCastingRecipe(class_3956<?> type, class_1865<?> serializer, class_2960 id, String group, class_1856 bottle, FluidIngredient fluid, class_1792 result, int coolingTime) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.bottle = bottle;
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public class_1865<?> method_8119() {
        return this.serializer;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<PotionCastingRecipe> {
        private final Supplier<class_3956<ICastingRecipe>> type;

        public PotionCastingRecipe fromJson(class_2960 id, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_1856 bottle = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"bottle"));
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            class_1792 result = (class_1792)JsonHelper.getAsEntry((class_2378)class_7923.field_41178, (JsonObject)json, (String)"result");
            int coolingTime = class_3518.method_15260((JsonObject)json, (String)"cooling_time");
            return new PotionCastingRecipe(this.type.get(), (class_1865<?>)this, id, group, bottle, fluid, result, coolingTime);
        }

        @Nullable
        protected PotionCastingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            class_1856 bottle = class_1856.method_8086((class_2540)buffer);
            FluidIngredient fluid = FluidIngredient.read((class_2540)buffer);
            class_1792 result = (class_1792)class_7923.field_41178.method_10223(buffer.method_10810());
            int coolingTime = buffer.method_10816();
            return new PotionCastingRecipe(this.type.get(), (class_1865<?>)this, id, group, bottle, fluid, result, coolingTime);
        }

        protected void toNetworkSafe(class_2540 buffer, PotionCastingRecipe recipe) {
            buffer.method_10814(recipe.group);
            recipe.bottle.method_8088(buffer);
            recipe.fluid.write(buffer);
            buffer.method_10812(class_7923.field_41178.method_10221((Object)recipe.result));
            buffer.method_10804(recipe.coolingTime);
        }

        public Serializer(Supplier<class_3956<ICastingRecipe>> type) {
            this.type = type;
        }
    }
}

